﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web;
using System.Web.UI;

namespace VIRP_WEB.Custom.BPR
{
    public static class Alert
    {

        /// <summary>
        /// Shows a client-side JavaScript alert in the browser.
        /// </summary>
        /// <param name="message">The message to appear in the alert.</param>
        public static void Show(string message)
        {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.Append(@"<script language=JavaScript>");
            stringBuilder.Append(@"alert('" + message + "');");
            stringBuilder.Append(@"</");
            stringBuilder.Append(@"script>");

            ((Page)HttpContext.Current.Handler).RegisterStartupScript(new Guid().ToString(),
                stringBuilder.ToString());
        }

        public static void ShowSaveSuccess()
        {
            Show("Save Successful!");
        }

        public static void ShowSubmitSuccess()
        {
            Show("Submit Successful!");
        }

        public static void ShowSaveFailed()
        {
            Show("Save Failed!");
        }

        public static void ShowSaveSuccessEmailSent()
        {
            Show("Save Successful & Email Sent to Registrant!");
        }

        public static void ShowSaveSuccessNoEmailSent()
        {
            Show("Save Successful & Email Not Sent(No email address for Registrant)!");
        }

        public static void ShowDeleteSuccessful()
        {
            Show("Delete Successful!");
        }

        public static void ShowDeactivationSuccessful()
        {
            Show("Deactivation Successful!");
        }

        public static void ShowActivationSuccessful()
        {
            Show("Activation Successful!");
        }

        public static void ShowMessageSentSuccessful()
        {
            Show("Send Successful!");
        }

        public static void ShowMessageNotSentSuccessful()
        {
            Show("No message sent!");
        }

        public static void ShowFlagSetSuccessful()
        {
            Show("Flag Set Successful!");
        }

        public static void ShowFlagSetFailed()
        {
            Show("Flag Set Failed!");
        }

    }
}